<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace WebserviceBundle\Tests\Services\UserSearch\Advanced\DataProvider\Doctrine;

use Sso\WebserviceBundle\Services\UserSearch\Advanced\DataProvider\Doctrine\Handler;
use Sso\WebserviceBundle\Services\UserSearch\Advanced\RequestData as Request;
use Sso\WebserviceBundle\Services\UserSearch\Advanced\Factory;
use Sso\WebserviceBundle\Services\UserSearch\Advanced\ResponseData\Factory as ResponseDataFactory;
use Sso\WebserviceBundle\Services\UserSearch\Advanced\ResponseData\Users as ResponseDTO;
use Psr\Log\LoggerInterface;
use Symfony\Bundle\FrameworkBundle\Test\KernelTestCase;

/**
 * Class HandlerTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package WebserviceBundle\Tests\Services\UserSearch\Advanced\DataProvider\Doctrine
 */
class HandlerTest extends KernelTestCase
{
    /**
     * @var \Doctrine\ORM\EntityManager
     */
    private $em;

    /**
     * @var LoggerInterface
     */
    private $logger;

    public function testGetResponseDTO()
    {
        $requestDTO = $this->buildRequest();
        $responseFactory = new ResponseDataFactory();
        $factory = $this->getMockBuilder(Factory::class)->disableOriginalConstructor()->getMock();
        $factory
            ->method('responseData')
            ->willReturn($responseFactory);

        $handler = new Handler($this->em, $this->logger);
        $responseDto = $handler->getResponseDTO($requestDTO, $factory);

        $this->assertInstanceOf(ResponseDTO::class, $responseDto);
    }

    /**
     * @return Request\UserSearch
     */
    private function buildRequest()
    {
        $userSearch = new Request\UserSearch();

        $userSearch->setLimit(10);
        $userSearch->setOffset(10);

        $attribute = new Request\AttributeType();
        $attribute->setName('foo');
        $attribute->setValue('bar');

        $app = new Request\ApplicationType();
        $app->setName('App4711');
        $app->setAttributeType($attribute);

        $filter = new Request\Filter();
        $filter->setApplicationType($app);
        $filter->setOperator('AND');
        $filter->setStrategy('EQ');

        $userSearch->addFilter($filter);

        $user = new Request\UserType();
        $user->setUsername('Oli42');

        $filter = new Request\Filter();
        $filter->setUserType($user);
        $filter->setOperator('AND');
        $filter->setStrategy('EQ');

        $userSearch->addFilter($filter);

        $user = new Request\UserType();
        $user->setLastname('Fri');

        $filter = new Request\Filter();
        $filter->setUserType($user);
        $filter->setOperator('AND');
        $filter->setStrategy('EQ');

        $userSearch->addFilter($filter);

        $user = new Request\UserType();
        $user->setEmail('Oli42@example.com');

        $filter = new Request\Filter();
        $filter->setUserType($user);
        $filter->setOperator('OR');
        $filter->setStrategy('EQ');

        $userSearch->addFilter($filter);

        $user = new Request\UserType();
        $user->setFirstname('Oli');

        $filter = new Request\Filter();
        $filter->setUserType($user);
        $filter->setOperator('AND');
        $filter->setStrategy('EQ');

        $userSearch->addFilter($filter);


        $subFilter = new Request\Filter();
        $subFilter->setOperator('OR');

        $userSearch->addFilter($subFilter);


        $user->setUsername('Oli42');

        $filter = new Request\Filter();
        $filter->setUserType($user);
        $filter->setOperator('AND');
        $filter->setStrategy('EQ');

        $subFilter->addFilter($filter);


        $user = new Request\UserType();
        $user->setUsername('Oli42');

        $filter = new Request\Filter();
        $filter->setUserType($user);
        $filter->setOperator('AND');
        $filter->setStrategy('EQ');

        $subFilter->addFilter($filter);

        return $userSearch;
    }

    /**
     * {@inheritDoc}
     */
    protected function setUp()
    {
        self::bootKernel();

        $this->em = static::$kernel->getContainer()
            ->get('doctrine')
            ->getManager('Webservice');

        $this->logger = $this->getMockBuilder(LoggerInterface::class)->getMock();
    }

    /**
     * {@inheritDoc}
     */
    protected function tearDown()
    {
        parent::tearDown();

        $this->em->close();
        $this->em = null; // avoid memory leaks
    }
}
