<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace WebserviceBundle\Tests\Services\UserSearch\Advanced\DataProvider\Doctrine\QueryBuilder\Helper;

use PHPUnit\Framework\TestCase;
use Sso\WebserviceBundle\Services\UserSearch\Advanced\DataProvider\Doctrine\QueryBuilder\Helper;
use Sso\WebserviceBundle\Services\UserSearch\Advanced\DataProvider\Doctrine\QueryBuilder\ExceptionCollection;

/**
 * Class ValidatorTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    WebserviceBundle\Tests\Services\UserSearch\Advanced\DataProvider\Doctrine\QueryBuilder\Helper
 */
class TransformerTest extends TestCase
{

    /**
     * @var Helper\Transformer
     */
    private $transformer;

    /**
     * {@inheritDoc}
     */
    protected function setUp()
    {
        $this->transformer = new Helper\Transformer();
    }

    public function testWildcards(){
        $this->assertEquals('%@oliver.com', $this->transformer->wildcardToPercent('****@oliver.com'));
        $this->assertEquals('%@stefan%', $this->transformer->wildcardToPercent('*@stefan*'));
    }
}
