<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Validator\Constraints;

use Sso\WebserviceBundle\Entity\Webservice\Type\User;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Sso\WebserviceBundle\Api\PasswordPolicy\Policy\Validator as PolicyValidatorService;

/**
 * Class PasswordPolicyValidator
 * @package Sso\WebserviceBundle\Validator\Constraints
 */
class PasswordPolicyValidator extends ConstraintValidator
{
    /**
     * @var PolicyValidatorService
     */
    private $validatorService;

    /**
     * PasswordPolicyValidator constructor.
     * @param PolicyValidatorService $validatorService
     */
    public function __construct(PolicyValidatorService $validatorService)
    {
        $this->validatorService = $validatorService;
    }

    /**
     * @param Object $userType
     * @param Constraint $constraint
     */
    public function validate($userType, Constraint $constraint)
    {
        if ($userType instanceof User) {
            if (!$this->validatorService->validateUserPolicy($userType)) {
                $this->context->buildViolation($constraint->message)
                    ->setParameter('{{ violations }}', implode(', ', $this->validatorService->getErrors()))
                    ->addViolation();
            }
        } else {
            $this->context
                ->buildViolation('Invalid object')
                ->addViolation();
        }
    }
}
