<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace LifeStyle\DH\AccessControlBundle\Configuration;

/**
 * Class IamAccessConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package LifeStyle\DH\AccessControlBundle\Configuration
 */
class IamAccessConfiguration
{
    /**
     * @var string
     */
    private $applicationName;

    /**
     * @var string
     */
    private $globalHrManagerRole;

    /**
     * IamAccessConfiguration constructor.
     * @param string $applicationName
     * @param string $globalHrManagerRole
     */
    public function __construct(string $applicationName, string $globalHrManagerRole)
    {
        $this->applicationName = $applicationName;
        $this->globalHrManagerRole = $globalHrManagerRole;
    }

    /**
     * @return string
     */
    public function getApplicationName(): string
    {
        return $this->applicationName;
    }

    /**
     * @return string
     */
    public function getGlobalHrManagerRole(): string
    {
        return $this->globalHrManagerRole;
    }
}
