<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace LifeStyle\DH\AccessControlBundle\Configuration;

/**
 * Class ScopeAccessConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package LifeStyle\DH\AccessControlBundle\Configuration
 */
class ScopeAccessConfiguration
{
    /**
     * @var string
     */
    private $applicationName;

    /**
     * @var string
     */
    private $primaryScopeProperty;

    /**
     * @var string
     */
    private $secondaryScopeProperty;

    /**
     * ScopeAccessConfiguration constructor.
     * @param string $applicationName
     * @param string $primaryScopeProperty
     * @param string $secondaryScopeProperty
     */
    public function __construct(string $applicationName, string $primaryScopeProperty, string $secondaryScopeProperty)
    {
        $this->applicationName = $applicationName;
        $this->primaryScopeProperty = $primaryScopeProperty;
        $this->secondaryScopeProperty = $secondaryScopeProperty;
    }

    /**
     * @return string
     */
    public function getApplicationName(): string
    {
        return $this->applicationName;
    }

    /**
     * @return string
     */
    public function getPrimaryScopeProperty(): string
    {
        return $this->primaryScopeProperty;
    }

    /**
     * @return string
     */
    public function getSecondaryScopeProperty(): string
    {
        return $this->secondaryScopeProperty;
    }
}
