<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace LifeStyle\DH\AccessControlBundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

/**
 * Class AccessControlExtension
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package LifeStyle\DH\AccessControlBundle\DependencyInjection
 */
class AccessControlExtension extends Extension
{
    /**
     * @return string
     */
    public function getAlias()
    {
        return 'life_style_dh_access_control';
    }

    /**
     * Loads a specific configuration.
     *
     * @param array $configs
     * @param ContainerBuilder $container
     * @throws \Exception
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = $this->getConfiguration($configs, $container);
        $config = $this->processConfiguration($configuration, $configs);

        (new Loader\YamlFileLoader($container, new FileLocator(dirname(__DIR__) . '/Resources/config')))
            ->load('services.yml');

        $this->configureClientConfiguration($config['http_client'], $container);
        $this->configureScopeAccessConfiguration($config['scope_configuration'], $container);
        $this->configureIamAccessConfiguration($config['iam_configuration'], $container);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureClientConfiguration(array $config, ContainerBuilder $container)
    {
        if (!$container->has('life_style_dh_access_control.configuration.client_configuration')) {
            return;
        }

        $definition = $container->findDefinition('life_style_dh_access_control.configuration.client_configuration');
        $definition->setArguments([
            $config['auth_token'],
            $config['base_url'],
        ]);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureScopeAccessConfiguration(array $config, ContainerBuilder $container)
    {
        if (!$container->has('life_style_dh_access_control.configuration.scope_access_configuration')) {
            return;
        }

        $definition = $container->findDefinition('life_style_dh_access_control.configuration.scope_access_configuration');
        $definition->setArguments([
            $config['application_name'],
            $config['primary_scope_attribute_name'],
            $config['secondary_scope_attribute_name'],
        ]);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureIamAccessConfiguration(array $config, ContainerBuilder $container)
    {
        if (!$container->has('life_style_dh_access_control.configuration.iam_access_configuration')) {
            return;
        }

        $definition = $container->findDefinition('life_style_dh_access_control.configuration.iam_access_configuration');
        $definition->setArguments([
            $config['application_name'],
            $config['global_hr_manager_role'],
        ]);
    }
}
