<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace LifeStyle\DH\AccessControlBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package LifeStyle\DH\AccessControlBundle\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * Generates the configuration tree builder.
     *
     * @return TreeBuilder The tree builder
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $treeBuilder
            ->root('life_style_dh_access_control')
                ->children()
                    ->arrayNode('http_client')
                        ->isRequired()
                        ->children()
                            ->scalarNode('auth_token')
                                ->isRequired()
                                ->cannotBeEmpty()
                                ->info('The security token to access the object service.')
                            ->end()
                            ->scalarNode('base_url')
                                ->isRequired()
                                ->cannotBeEmpty()
                                ->info('The base-url to the object service.')
                                ->validate()
                                    ->ifTrue(function ($baseUrl) {
                                        return false === filter_var($baseUrl, FILTER_VALIDATE_URL);
                                    })
                                    ->thenInvalid('This is not a valid URL.')
                                ->end()
                                ->example('https://my-object-ws.service')
                            ->end()
                        ->end()
                    ->end()
                    ->arrayNode('scope_configuration')
                        ->isRequired()
                        ->children()
                            ->scalarNode('application_name')
                                ->isRequired()
                                ->cannotBeEmpty()
                                ->info('The name of the user-application where the users primary and secondary scopes are stored.')
                            ->end()
                            ->scalarNode('primary_scope_attribute_name')
                                ->isRequired()
                                ->cannotBeEmpty()
                                ->info('The name of the user-application property for the primary scope.')
                            ->end()
                            ->scalarNode('secondary_scope_attribute_name')
                                ->isRequired()
                                ->cannotBeEmpty()
                                ->info('The name of the user-application property for the secondary scope.')
                            ->end()
                        ->end()
                    ->end()
                    ->arrayNode('iam_configuration')
                        ->isRequired()
                        ->children()
                            ->scalarNode('application_name')
                                ->isRequired()
                                ->cannotBeEmpty()
                                ->info('The name of the iam-application.')
                            ->end()
                            ->scalarNode('global_hr_manager_role')
                                ->isRequired()
                                ->cannotBeEmpty()
                                ->info('The role name for global access.')
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
