<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\DH\AttributeGeneratorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class AttributeEmployeeId
 *
 * @ORM\Table(name="dh_attribute_employee_id")
 * @ORM\Entity()
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\DH\AttributeGeneratorBundle\Entity
 */
class AttributeEmployeeId
{
    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\Column(type="integer", nullable=false)
     */
    private $id;

    /**
     * @param int $id
     * @return AttributeEmployeeId
     */
    public static function create(int $id): AttributeEmployeeId
    {
        return new self($id);
    }

    /**
     * AttributeEmployeeId constructor.
     * @param int $id
     */
    private function __construct(int $id)
    {
        $this->id = $id;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getEmployeeId(): string
    {
        return 'u' . sprintf('%06d', $this->id);
    }
}
