#Sulu Swoox Content Filter Bundle

SwooxBundle
========
Swoox Bundle to connect with SWOOX API and fetch categories, brands and products from endpoints for the [Sulu CMS](http://sulu.io).

# Installation
## Step 1: Download the bundle
Clone repository `git clone http://stash.life-style.de/scm/juw/swooxapi.git .` to a `vendor` or `src` directory of Sulu instance.

## Step 2: Enable the bundle
Enable the bundle in the Sulu `app/AbstractKernel.php` (for frontend and administration panel).

```php
<?php
public function registerBundles()
{
    $bundles = array(
        // ...
        new LifeStyle\SwooxBundle\LifeStyleSwooxBundle(),
    );
}
```

# Configuration
You can change the configuration by adding the following lines to the bundle `config.yml`:

```yml
life_style_swoox:
    api_url: 'http://swoox-6-api.test.life-style.de'
    api_ext: '.json' # could be also .xml
    client_id: 5 # unique client ID
    endpoints:
        filter: '/api/v1/search/filter'
        standard: '/api/v1/search/standard'
    images_url: 'http://pimcore.juweliere.test.life-style.de'
```

# Documentation
Documentation is provided by [ApiDocBundle](https://github.com/nelmio/NelmioApiDocBundle) and is available under `/swoox/api/doc` route of your project.

# Development
If you have changed JavaScript files, you need to:
- run `npm install` from console
- run `npm run build` to generate `dist/main.js` file
