<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\Swoox\ContentFilterBundle\Content\Extension;

use PHPCR\NodeInterface;
use Sulu\Component\Content\Extension\AbstractExtension;

/**
 * Class SwooxContentFilterExtension
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Sulu\Swoox\ContentFilterBundle\Content\Extension
 */
class SwooxContentFilterExtension extends AbstractExtension
{
    /**
     * {@inheritdoc}
     */
    protected $properties = [
        'link',
    ];

    /**
     * save data to node.
     *
     * @param NodeInterface $node
     * @param mixed $data
     * @param string $webspaceKey
     * @param string $languageCode
     */
    public function save(NodeInterface $node, $data, $webspaceKey, $languageCode)
    {
        $this->saveProperty($node, $data, 'link');
    }

    /**
     * load data from node.
     *
     * @param NodeInterface $node
     * @param string $webspaceKey
     * @param string $languageCode
     *
     * @return mixed data of extension
     */
    public function load(NodeInterface $node, $webspaceKey, $languageCode)
    {
        return $this->loadProperty($node, 'link');
    }
}
