/*
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

require.config({
    paths: {
        swooxcontentfilter: '../../lifestylesuluswooxcontentfilter/js',
        swooxcontentfiltercss: '../../lifestylesuluswooxcontentfilter/css'
    }
});

define(['css!swooxcontentfiltercss/main.css'], function () {
    'use strict';
    return {
        name: 'Swoox Content Filter Bundle',
    };
});

function updateSwooxFilter(button) {
    var container = $(button).closest('.js-swoox-content-filter');
    var formValues = container.find('.js-swoox-filter-form :input').filter(function (index, ele) {

        // Skip hidden fields and empty values
        var element = $(ele);
        if (element.attr('type') === 'hidden' || element.val() === "") {
            return false;
        }

        // TODO: Fix for range elements: validate selected values. If not valid, return false.

        return true;
    }).serialize();
    container
        .find('.js-swoox-filter-input')
        .val(decodeURIComponent(formValues))
        .keyup();
}
