<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\Swoox\ContentFilterBundle\Twig\Extension;

use Symfony\Component\Form\FormView;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

/**
 * Class SearchFilterFormExtension
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Sulu\Swoox\ContentFilterBundle\Twig\Extension
 */
class SearchFilterFormExtension extends AbstractExtension
{
    /**
     * @return array|\Twig_Function[]
     */
    public function getFunctions()
    {
        return [
            new TwigFunction('ls_filter_form_has_visible_fields', array($this, 'hasVisibleFields')),
        ];
    }

    /**
     * @param FormView $form
     * @return bool
     */
    public function hasVisibleFields(FormView $form): bool
    {
        foreach ($form as $formElement) {
            foreach ($formElement->vars['block_prefixes'] as $prefix) {
                if (!in_array($prefix, ['form', '_', '_q', 'hidden', 'button', 'submit', '_filter', '__token'])) {
                    return true;
                }
            }
            if ($this->hasVisibleFields($formElement)) {
                return true;
            }
        }
        return false;
    }
}
