<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\Swoox\ContentFilterBundle\Admin;

use Sulu\Bundle\AdminBundle\Admin\Admin;
use Sulu\Bundle\AdminBundle\Navigation\Navigation;
use Sulu\Bundle\AdminBundle\Navigation\NavigationItem;

/**
 * Class LifeStyleSuluSwooxContentFilterAdmin
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Sulu\Swoox\ContentFilterBundle\Admin
 */
class LifeStyleSuluSwooxContentFilterAdmin extends Admin
{
    /**
     * LifeStyleSuluSwooxContentFilterAdmin constructor.
     * @param string $title
     */
    public function __construct($title)
    {
        // Looks like this has to be done - but does not have any effect
        $rootNavigationItem = new NavigationItem($title);
        $this->setNavigation(new Navigation($rootNavigationItem));
    }

    /**
     * Enable javascript loading
     *
     * @return string
     */
    public function getJsBundleName()
    {
        return 'lifestylesuluswooxcontentfilter';
    }
}
