<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\Swoox\ContentFilterBundle\Content\Types;

use function GuzzleHttp\Psr7\parse_query;
use LifeStyle\Sulu\Swoox\ContentFilterBundle\AdminHelper\QueryParser;
use LifeStyle\Sulu\Swoox\ContentFilterBundle\AdminHelper\RequestParser;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\View\SearchEngineInterface;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\View\FilterEngineInterface;
use Sulu\Component\Content\Compat\PropertyInterface;
use Sulu\Component\Content\SimpleContentType;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class SwooxContent
 *
 * Content element for Sulu
 *
 * Sends standard search request to Swoox with fixed filters which have
 * to be configured in Sulu admin within the content element
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Sulu\Swoox\ContentFilterBundle\Content\Types
 */
class SwooxContent extends SimpleContentType
{
    use QueryParser;

    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * SwooxSearch constructor.
     * @param ContainerInterface $container
     * @param null $template
     */
    public function __construct(
        ContainerInterface $container,
        $template
    ) {
        parent::__construct('SwooxContent', '');
        $this->container = $container;
        $this->template = $template;
    }

    /**
     * Returns a template to render a form.
     *
     * @return string
     */
    public function getTemplate()
    {
        return $this->template;
    }

    /**
     * {@inheritdoc}
     */
    public function getDefaultParams(PropertyInterface $property = null)
    {
        $request = $this->container->get('request_stack')->getCurrentRequest();
        $searchParams = $this->container->get(RequestParser::class)->parseRequest($request);
        $locale = $request->query->get('language');
        $filterForm = $this->container->get(FilterEngineInterface::class)->buildFilterForm($searchParams, $locale);

        // Admin
        return [
            'filterForm' => $filterForm->createView(),
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function getContentData(PropertyInterface $property)
    {
        $locale = $this->container->get('sulu_core.webspace.request_analyzer')->getCurrentLocalization()->getLocale();
        $searchParams = $this->parseQuery($property->getValue());

        // Frontend
        return [
            'searchResultItems' => $this->container->get(SearchEngineInterface::class)->paginatedSearch($searchParams, $locale),
        ];
    }
}
