<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\Swoox\ContentFilterBundle\Content\Types;

use LifeStyle\Sulu\Swoox\ContentFilterBundle\AdminHelper\RequestParser;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\View\FilterEngineInterface;
use Sulu\Component\Content\Compat\PropertyInterface;
use Sulu\Component\Content\SimpleContentType;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class SwooxContentFilter
 *
 * @deprecated Since version 1.1, will be removed in Version 2.0, use LifeStyle\Sulu\Swoox\ContentFilterBundle\Content\Types\SwooxSearch instead
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Sulu\Swoox\ContentFilterBundle\Content\Types
 */
class SwooxContentFilter extends SimpleContentType
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * SwooxContentFilter constructor.
     * @param ContainerInterface $container
     * @param null $template
     */
    public function __construct(
        ContainerInterface $container,
        $template
    ) {
        parent::__construct('SwooxContentFilter', '');
        $this->container = $container;
        $this->template = $template;
    }

    /**
     * Returns a template to render a form.
     *
     * @return string
     */
    public function getTemplate()
    {
        return $this->template;
    }

    /**
     * {@inheritdoc}
     */
    public function getDefaultParams(PropertyInterface $property = null)
    {
        $request = $this->container->get('request_stack')->getCurrentRequest();
        $searchParams = $this->container->get(RequestParser::class)->parseRequest($request);
        $locale = $request->query->get('language');
        $filterForm = $this->container->get(FilterEngineInterface::class)->buildFilterForm($searchParams, $locale);

        // Admin
        return [
            'filterForm' => $filterForm->createView(),
        ];
    }
}
