<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sulu\TaxonBundle\Mapper;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sulu\TaxonBundle\Entity\Taxon;

/**
 * Class MessageMapper
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sulu\TaxonBundle\Mapper
 */
class MessageMapper
{
    /**
     * @param Taxon $taxon
     * @param DataCollectorInterface $dataCollector
     * @param string $locale
     */
    public function map(Taxon $taxon, DataCollectorInterface $dataCollector, string $locale): void
    {
        $taxon->setTaxonId((int)$dataCollector->getItemValue('id'));
        $parentTaxonId = $dataCollector->getItemValue('parentTaxonId');
        $taxon->setTaxonParentId(0 < strlen($parentTaxonId) ? (int)$parentTaxonId : null);
        $taxon->setLocale($locale);
        $taxon->setName($dataCollector->getItemValue('name', $locale));
        $taxon->setSlug((string)$dataCollector->getItemValue('slug', $locale));
        $taxon->setDescription($dataCollector->getItemValue('description', $locale));
    }
}
