<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sulu\TaxonBundle\Mapper;

use Lifestyle\Sulu\TaxonBundle\Entity\Taxon;

/**
 * Class OptionSelectMapper
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sulu\TaxonBundle\Mapper
 */
class OptionSelectMapper
{
    /**
     * @var Taxon[]
     */
    private $taxons;

    /**
     * @param Taxon[] $taxons
     */
    public function setTaxons(array $taxons): void
    {
        $this->taxons = [];
        foreach ($taxons as $taxon) {
            $this->addTaxon($taxon);
        }
    }

    /**
     * @param Taxon $taxon
     */
    private function addTaxon(Taxon $taxon): void
    {
        $this->taxons[] = $taxon;
    }

    /**
     * @return array
     */
    public function map(): array
    {
        return $this->mapOptions($this->taxons);
    }

    /**
     * @param Taxon[] $taxons
     * @return array
     */
    private function mapOptions(array $taxons): array
    {
        $options = [];
        foreach ($taxons as $taxon) {
            $options[$this->getBreadcrumb($taxon)] = $taxon->getId();
        }
        ksort($options);
        return $options;
    }

    /**
     * Creates a full slug from root to leave
     *
     * @param Taxon $currentTaxon
     * @return string
     */
    private function getBreadcrumb(Taxon $currentTaxon): string
    {
        $parentTaxonId = $currentTaxon->getTaxonParentId();
        if (null === $parentTaxonId) {
            return $currentTaxon->getName();
        }

        $parentName = '';
        foreach ($this->taxons as $taxon) {
            if ($taxon->getTaxonId() === $parentTaxonId) {
                $parentName = $this->getBreadcrumb($taxon);
            }
        }

        return $parentName . ' / ' . $currentTaxon->getName();
    }
}
