<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sulu\TaxonBundle\Database;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\OptimisticLockException;
use Lifestyle\Sulu\TaxonBundle\Exception\DatabaseException;

/**
 * Trait ReconnectTrait
 * @package Lifestyle\Sylius\Product\ProductHelper
 */
trait ReconnectTrait
{
    /**
     * @param EntityManagerInterface $entityManager
     * @return EntityManagerInterface
     * @throws \Doctrine\ORM\ORMException
     */
    private function getClearedEntityManager(EntityManagerInterface $entityManager): EntityManagerInterface
    {
        $connection = $entityManager->getConnection();
        $configuration = $entityManager->getConfiguration();

        // Reconnect
        if (!$connection->ping()) {
            $connection->close();
            $connection->connect();
        }

        // Create new entity manager, if is closed
        if (!$entityManager->isOpen()) {
            $entityManager = EntityManager::create($connection, $configuration);
        }

        // Remove every unsaved entities from previous actions
        $entityManager->clear();

        return $entityManager;
    }

    /**
     * @param EntityManagerInterface $entityManager
     * @param mixed $object
     * @throws DatabaseException
     */
    public function flush(EntityManagerInterface $entityManager)
    {
        $done = false;
        $failures = 0;
        do {
            try {
                $entityManager->flush();
                $done = true;
            } catch (OptimisticLockException $exception) {
                ++$failures;
                if (3 < $failures) {
                    throw new DatabaseException(
                        sprintf(
                            'Failed writing to database after %d retries.',
                            $failures
                        ),
                        $exception->getCode(),
                        $exception
                    );
                }
                usleep(100);
            }
        } while (!$done);
    }
}
