#Sulu Taxon Bundle

... for the [Sulu CMS](http://sulu.io).

## Requirements

- Sulu Version 1.6
- PHP7.2

## Installation

You must have access to the Life-Style repository. Add the following to the `repositories` section of your projects `composer.json`

```yaml
    "repositories": [
        ...
        {
            "type": "git",
            "url": "ssh://git@stash.life-style.de:7999/sb/data-collector-model.git"
        },
        {
            "type": "git",
            "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylerabbitmqconsumerbundle.git"
        },
        {
            "type": "git",
            "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylerabbitmqproducerbundle.git"
        },
        {
            "type": "git",
            "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesulutaxonbundle.git"
        }
    ]
``` 

and install the package:

```bash
composer require lifestyle/sulu-taxon-bundle
```

Add the bundle to your Kernel `app/AbstractKernel.php`. You also have to enable the Symfony webpack-encore bundle, if not already done:

```php
abstract class AbstractKernel extends SuluKernel
{
    public function registerBundles()
    {
        $bundles = [
            ...
            new Lifestyle\Sulu\TaxonBundle\LifestyleSuluTaxonBundle(),
            ...
        ];
        ...
    }
    ...
}
```

## Configuration

Be sure you have configured the rabbitMQ consumer and producer and your rabbitMQ-servers exchange and queues. Using the _product_data_-consumer this bundle consumes taxon-update-messages from Pimcore. It also sends taxon-update-messages to Pimcore using the _taxon_data_-producer.

_app/config/config.yml_:
```yaml
old_sound_rabbit_mq:
    connections:
        default:
            url: '%env(RABBITMQ_URL)%'
    consumers:
        product_data:
            connection: default
            callback: Lifestyle\RabbitMq\Consumer\Consumer\Consumer
            queue_options: { name: '%env(RABBITMQ_SULU_QUEUE_NAME)%' }
            enable_logger: true
            auto_setup_fabric: false
    producers:
        [...]
        taxon_data:
            connection: default
            auto_setup_fabric: false
            exchange_options: { name: '%env(RABBITMQ_SULU_TAXON_EXCHANGE_NAME)%', type: 'THIS_HAS_NO_EFFECT_IF_NO_AUTO_SETUP_FABRIC' }
            enable_logger: true

lifestyle_rabbit_mq_producer:
    handler:
        -
            producer: 'taxon_data'
            message_options:
                delivery_mode: 2 # AMQPMessage::DELIVERY_MODE_PERSISTENT
            events:
                - 'taxon.url.update'
```

_.env_:
```yaml
RABBITMQ_URL=amqp://user:password@localhost:5672?vhost=my_vhost
RABBITMQ_SULU_TAXON_EXCHANGE_NAME=sulu-taxon-producer
RABBITMQ_SULU_EXCHANGE_NAME=sulu-producer
RABBITMQ_SULU_QUEUE_NAME=sulu-consumer
```
