<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sulu\TaxonBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class Taxon
 *
 * @ORM\Entity(repositoryClass="Lifestyle\Sulu\TaxonBundle\Repository\TaxonRepository")
 * @ORM\Table(name="ls_taxon")
 * @ORM\HasLifecycleCallbacks()
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sulu\TaxonBundle\Entity
 */
class Taxon
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(name="id", type="integer")
     * @var int
     */
    private $id;

    /**
     * @ORM\Column(name="created_at", type="datetime")
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @ORM\Column(name="updated_at", type="datetime")
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * @ORM\Column(name="taxon_id", type="integer")
     * @var int
     */
    private $taxonId;

    /**
     * @ORM\Column(name="taxon_parent_id", type="integer", nullable=true)
     * @var int|null
     */
    private $taxonParentId;

    /**
     * @ORM\Column(name="locale", type="string", length=12)
     * @var string
     */
    private $locale;

    /**
     * @ORM\Column(name="name", type="string", length=255, nullable=true)
     * @var string|null
     */
    private $name;

    /**
     * @ORM\Column(name="description", type="string", length=255, nullable=true)
     * @var string|null
     */
    private $description;

    /**
     * @ORM\Column(name="slug", type="string", length=255, nullable=true)
     * @var string|null
     */
    private $slug;

    /**
     * Absolute url for taxon
     *
     * @ORM\Column(name="url", type="string", length=255, nullable=true)
     * @var string|null
     */
    private $url;

    /**
     * Taxon constructor.
     */
    public function __construct()
    {
        $this->createdAt = new \DateTime();
        $this->updatedAt = new \DateTime();
    }

    /**
     * @ORM\PrePersist()
     */
    public function onPrePersist()
    {
        $this->updatedAt = new \DateTime();
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId(int $id): void
    {
        $this->id = $id;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt(): \DateTime
    {
        return $this->createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt(): \DateTime
    {
        return $this->updatedAt;
    }

    /**
     * @return int
     */
    public function getTaxonId(): int
    {
        return $this->taxonId;
    }

    /**
     * @param int $taxonId
     */
    public function setTaxonId(int $taxonId): void
    {
        $this->taxonId = $taxonId;
    }

    /**
     * @return int|null
     */
    public function getTaxonParentId(): ?int
    {
        return $this->taxonParentId;
    }

    /**
     * @param int|null $taxonParentId
     */
    public function setTaxonParentId(?int $taxonParentId): void
    {
        $this->taxonParentId = $taxonParentId;
    }

    /**
     * @return string
     */
    public function getLocale(): string
    {
        return $this->locale;
    }

    /**
     * @param string $locale
     */
    public function setLocale(string $locale): void
    {
        $this->locale = $locale;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     */
    public function setName(?string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @param string|null $description
     */
    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }

    /**
     * @return string|null
     */
    public function getSlug(): ?string
    {
        return $this->slug;
    }

    /**
     * @param string|null $slug
     */
    public function setSlug(?string $slug): void
    {
        $this->slug = $slug;
    }

    /**
     * @return string|null
     */
    public function getUrl(): ?string
    {
        return $this->url;
    }

    /**
     * @param string|null $url
     */
    public function setUrl(?string $url): void
    {
        $this->url = $url;
    }
}
