<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sulu\TaxonBundle\MessageProducer;

use Lifestyle\RabbitMq\Producer\Producer\ProducerInterface;
use Lifestyle\Sulu\TaxonBundle\Entity\Taxon;
use Lifestyle\Sulu\TaxonBundle\RequestData\Factory;
use Psr\Log\LoggerInterface;

/**
 * Class TaxonUpdateProducer
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sulu\TaxonBundle\MessageProducer
 */
class TaxonUpdateProducer
{
    /**
     * @var Factory
     */
    private $requestFactory;

    /**
     * @var ProducerInterface
     */
    private $producer;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * TaxonUpdateProducer constructor.
     * @param Factory $requestFactory
     * @param ProducerInterface $producer
     * @param LoggerInterface $logger
     */
    public function __construct(Factory $requestFactory, ProducerInterface $producer, LoggerInterface $logger)
    {
        $this->requestFactory = $requestFactory;
        $this->producer = $producer;
        $this->logger = $logger;
    }

    /**
     * @param Taxon $taxon
     * @param string $url
     */
    public function send(Taxon $taxon, string $url)
    {
        $dataCollector = $this->requestFactory->dataCollector();
        $dataCollector->addItem('id', $taxon->getTaxonId());
        $dataCollector->addItem('url', $url, $taxon->getLocale());

        if (!$this->producer->send('taxon.url.update', $dataCollector)) {
            $this->logger->error(sprintf(
                'Error while sending message to update taxon-url: %s for taxon-id: %d',
                $url,
                $taxon->getTaxonId()
            ));
        }
    }
}
