<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sulu\TaxonBundle\MessageHandler;

use Doctrine\ORM\EntityManagerInterface;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\RabbitMq\Consumer\Handler\HandlerInterface;
use Lifestyle\Sulu\TaxonBundle\Database\ReconnectTrait;
use Lifestyle\Sulu\TaxonBundle\Entity\Taxon;
use Lifestyle\Sulu\TaxonBundle\Repository\TaxonRepository;

/**
 * Class TaxonUnpublishHandler
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sulu\TaxonBundle\MessageHandler
 */
class TaxonUnpublishHandler implements HandlerInterface
{
    use ReconnectTrait;

    /**
     * @var EntityManagerInterface
     */
    private $objectManager;

    /**
     * TaxonUnpublishHandler constructor.
     * @param EntityManagerInterface $objectManager
     */
    public function __construct(EntityManagerInterface $objectManager)
    {
        $this->objectManager = $objectManager;
    }

    /**
     * @param DataCollectorInterface $dataCollector
     * @return bool Should return true, if data has been processed
     * @throws \Doctrine\ORM\ORMException
     * @throws \Lifestyle\Sulu\TaxonBundle\Exception\DatabaseException
     */
    public function handle(DataCollectorInterface $dataCollector): bool
    {
        if (!$this->isResponsible($dataCollector)) {
            return false;
        }

        $this->objectManager = $this->getClearedEntityManager($this->objectManager);
        /** @var TaxonRepository $objectRepository */
        $objectRepository = $this->objectManager->getRepository(Taxon::class);

        $taxonId = $dataCollector->getItemValue('id');
        foreach ($objectRepository->findByTaxonId($taxonId) as $taxon) {
            $this->objectManager->remove($taxon);
        }

        $this->flush($this->objectManager);

        return true;
    }

    /**
     * @param DataCollectorInterface $dataCollector
     * @return bool
     */
    private function isResponsible(DataCollectorInterface $dataCollector): bool
    {
        return 0 === strcasecmp($dataCollector->getItemValue('event'), 'taxon.unpublish');
    }
}
