<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sulu\TaxonBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Lifestyle\Sulu\TaxonBundle\Entity\Taxon;

/**
 * Class TaxonRepository
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sulu\TaxonBundle\Repository
 */
class TaxonRepository extends EntityRepository
{
    /**
     * @param int $taxonId
     * @param string $locale
     * @return Taxon|null
     */
    public function findOneByTaxonIdAndLocale(int $taxonId, string $locale):? Taxon
    {
        $taxon = $this->findOneBy([
            'taxonId' => $taxonId,
            'locale' => $locale,
        ]);
        return $taxon instanceof Taxon ? $taxon : null;
    }

    /**
     * @param int $taxonId
     * @return Taxon[]
     */
    public function findByTaxonId(int $taxonId): array
    {
        return $this->findBy([
            'taxonId' => $taxonId,
        ]);
    }

    /**
     * @param string $locale
     * @return Taxon[]
     */
    public function findByLocale(string $locale): array
    {
        return $this->findBy([
            'locale' => $locale,
        ]);
    }

    /**
     * @param string $slug
     * @param string $locale
     * @return Taxon|null
     */
    public function findOneBySlugAndLocale(string $slug, string $locale):? Taxon
    {
        $taxon = $this->findOneBy([
            'slug' => $slug,
            'locale' => $locale,
        ]);
        return $taxon instanceof Taxon ? $taxon : null;
    }
}
