<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate\ResponseData;

/**
 * Class ResponseData
 * @package LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate\ResponseData
 */
class ResponseData
{
    /**
     * @var string
     */
    private $locale;

    /**
     * @var string
     */
    private $webspace;

    /**
     * @var string
     */
    private $headerHtml;

    /**
     * @var string
     */
    private $footerHtml;

    /**
     * ResponseData constructor.
     * @param string $locale
     * @param string $webspace
     * @param string $headerHtml
     * @param string $footerHtml
     */
    public function __construct(string $locale, string $webspace, string $headerHtml, string $footerHtml)
    {
        $this->locale = $locale;
        $this->webspace = $webspace;
        $this->headerHtml = $headerHtml;
        $this->footerHtml = $footerHtml;
    }

    /**
     * @return string
     */
    public function getLocale(): string
    {
        return $this->locale;
    }

    /**
     * @return string
     */
    public function getWebspace(): string
    {
        return $this->webspace;
    }

    /**
     * @return string
     */
    public function getHeaderHtml(): string
    {
        return $this->headerHtml;
    }

    /**
     * @return string
     */
    public function getFooterHtml(): string
    {
        return $this->footerHtml;
    }
}
