<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Sulu\TemplateApiBundle\DependencyInjection;

use LifeStyle\Sulu\TemplateApiBundle\Configuration\ConfigModel;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * Class LifeStyleSuluTemplateApiExtension
 * @package LifeStyle\Sulu\TemplateApiBundle\DependencyInjection
 */
class LifeStyleSuluTemplateApiExtension extends Extension
{
    /**
     * @param array $configs
     * @param ContainerBuilder $container
     * @throws \Exception
     */
    public function load(array $configs, ContainerBuilder $container)
    {

        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $this->configureConfigModel($config, $container);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureConfigModel(array $config, ContainerBuilder $container)
    {

        if (!$container->hasDefinition(ConfigModel::class)) {
            return;
        }

        $urls = [];
        foreach ($config['available_languages'] as $urlLang){
            $urls[$urlLang] = "/";
        }

        $definition = $container->getDefinition(ConfigModel::class);
        $definition->setArguments([$urls]);
    }
}
