<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Sulu\TemplateApiBundle\EventListener;

use Symfony\Component\HttpKernel\Event\GetResponseEvent;

/**
 * Class PerformanceListener
 * @package LifeStyle\Sylius\PricingPlugin\EventListener
 */
class PerformanceListener
{
    /**
     * @var string
     */
    private $startTime;

    /**
     * @param GetResponseEvent $event
     */
    public function onKernelRequest(GetResponseEvent $event)
    {
        $this->startTime = microtime(true);
    }

    /**
     * @return double
     */
    public function getScriptSeconds()
    {
        return round(microtime(true) - $this->startTime, 4);
    }
}
