<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate;

use LifeStyle\Sulu\TemplateApiBundle\Configuration\ConfigModel;
use LifeStyle\Sulu\TemplateApiBundle\Services\HandlerInterface;
use LifeStyle\Sulu\TemplateApiBundle\Services\ResponseInterface;
use LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate\Response\ResponeBuilderFactory;
use LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate\ResponseData\ResponseDataFactory;
use Symfony\Component\HttpFoundation\Request;
use Sulu\Bundle\WebsiteBundle\Twig\Navigation\NavigationTwigExtension;
use Symfony\Bundle\TwigBundle\TwigEngine;

/**
 * Class Handler
 * @package LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate
 */
class Handler implements HandlerInterface
{
    /**
     * @var ResponseDataFactory
     */
    private $responseDataFactory;

    /**
     * @var ResponeBuilderFactory
     */
    private $responseBuilderFactory;

    /**
     * @var TwigEngine
     */
    private $twigEngine;

    /**
     * @var ConfigModel
     */
    private $configModel;

    /**
     * Handler constructor.
     * @param ResponseDataFactory $responseDataFactory
     * @param ResponeBuilderFactory $responseBuilderFactory
     * @param TwigEngine $twigEngine
     * @param ConfigModel $configModel
     */
    public function __construct(
        ResponseDataFactory $responseDataFactory,
        ResponeBuilderFactory $responseBuilderFactory,
        TwigEngine $twigEngine,
        ConfigModel $configModel
    ) {
        $this->responseDataFactory = $responseDataFactory;
        $this->responseBuilderFactory = $responseBuilderFactory;
        $this->twigEngine = $twigEngine;
        $this->configModel = $configModel;
    }

    /**
     * @param Request $request
     * @return ResponseInterface
     * @throws \Exception
     */
    public function handle(Request $request): ResponseInterface
    {
        $headerTwig = '@LifestyleSuluTemplate/templates/includes/header/header.html.twig';
        $footerTwig = '@LifestyleSuluTemplate/templates/includes/footer/footer.html.twig';

        /**
         * @var \Sulu\Component\Webspace\Analyzer\Attributes\RequestAttributes $suluRequest
         */
        $suluRequest = $request->attributes->get('_sulu', null);

        if(null !== $suluRequest){
            $locale = $suluRequest->getAttribute('locale', 'not found');
            $webspace = $suluRequest->getAttribute('webspace', null) ? $suluRequest->getAttribute('webspace')->getName() : 'not found';
        } else {
            $locale = 'not found';
            $webspace = 'not found';
        }

        $headerHtml = $this->twigEngine->render($headerTwig, ['urls' => $this->configModel->getAvailableLanguages()]);
        $footerHtml = $this->twigEngine->render($footerTwig);

        //set responseData
        $responseData = $this->responseDataFactory->responseData($locale, $webspace, $headerHtml, $footerHtml);

        return $this->responseBuilderFactory->createResponseBuilder()->buildResponse($responseData);
    }
}
