# Life-Style - Sulu Template Api Bundle

... for the [Sulu CMS](http://sulu.io).

## Requirements

- Sulu Version 1.6
- PHP7.2

## Installation

```bash
composer require lifestyle/sulu-template-api-bundle
```

1\. add to abstract kernel `app/AbstractKernel.php`

```php
abstract class AbstractKernel extends SuluKernel
{
    public function registerBundles()
    {
        $bundles = [
            ...
            new LifeStyle\Sulu\TemplateApiBundle\LifeStyleSuluTemplateApiBundle(),
            ...
        ];
        ...
    }
    ...
}
```

2\. add route `app/config/website/routing.yml`

```yaml
life_style_api_route:
    resource: "@LifeStyleSuluTemplateApiBundle/Resources/config/routing.yml"
    prefix: /
```

3\. add the configuration to your `app/config/config.yml`

```yaml
life_style_sulu_template_api:
    available_languages: ['de', 'en']
    header_template: '@LifestyleSuluTemplate/templates/includes/header/header.html.twig'
    footer_template: '@LifestyleSuluTemplate/templates/includes/footer/footer.html.twig'
```

4\. example request

```
GET http://your-domain.tld/{locale}/api/template.json
```

5\. example response

```json
{
    "scriptTimeSec": 0.5397,
    "locale": "de",
    "webspace": "sulu-webspace-name",
    "headerHtml": "some html markup",  
    "footerHtml": "some html markup"
}
```

good luck and have fun!
