<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate\Response;

use LifeStyle\Sulu\TemplateApiBundle\EventListener\PerformanceListener;
use LifeStyle\Sulu\TemplateApiBundle\Helper\VersionInflector;
use LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate\ResponseBuilderInterface;

/**
 * Class ResponeBuilderFactory
 * @package LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate\ResponseData\Response
 */
class ResponeBuilderFactory
{
    /**
     * @var VersionInflector
     */
    private $versionInflector;

    /**
     * @var PerformanceListener
     */
    private $performance;

    /**
     * ResponeBuilderFactory constructor.
     * @param VersionInflector $versionInflector
     * @param PerformanceListener $performance
     */
    public function __construct(VersionInflector $versionInflector, PerformanceListener $performance)
    {
        $this->versionInflector = $versionInflector;
        $this->performance = $performance;
    }

    /**
     * @return ResponseBuilderInterface
     * @throws \Exception
     */
    public function createResponseBuilder(): ResponseBuilderInterface
    {
        $className = $this->versionInflector->inflect(__NAMESPACE__, 'ResponseBuilder');
        return new $className($this->performance);
    }
}
