<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate\Response\Version1;

use LifeStyle\Sulu\TemplateApiBundle\Services\ResponseInterface;

/**
 * Class Response
 * @package LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate\Response\Version1
 */
class Response implements ResponseInterface
{
    /**
     * @var double
     */
    private $scriptTimeSec;

    /**
     * @var string
     */
    private $locale;

    /**
     * @var string
     */
    private $webspace;

    /**
     * @var string
     */
    private $headerHtml;

    /**
     * @var string
     */
    private $footerHtml;

    /**
     * @param float $scriptTimeSec
     */
    public function setScriptTimeSec(float $scriptTimeSec): void
    {
        $this->scriptTimeSec = $scriptTimeSec;
    }

    /**
     * @param string $locale
     */
    public function setLocale(string $locale): void
    {
        $this->locale = $locale;
    }

    /**
     * @param string $webspace
     */
    public function setWebspace(string $webspace): void
    {
        $this->webspace = $webspace;
    }

    /**
     * @param string $headerHtml
     */
    public function setHeaderHtml(string $headerHtml): void
    {
        $this->headerHtml = $headerHtml;
    }

    /**
     * @param string $footerHtml
     */
    public function setFooterHtml(string $footerHtml): void
    {
        $this->footerHtml = $footerHtml;
    }
}
