<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

declare(strict_types=1);

namespace LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate\Response\Version1;

use LifeStyle\Sulu\TemplateApiBundle\EventListener\PerformanceListener;
use LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate\ResponseBuilderInterface;
use LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate\ResponseData\ResponseData;
use LifeStyle\Sulu\TemplateApiBundle\Services\ResponseInterface;

/**
 * Class ResponseBuilder
 * @package LifeStyle\Sulu\TemplateApiBundle\Services\ShowTemplate\ResponseData\Response\Version1
 */
class ResponseBuilder implements ResponseBuilderInterface
{
    /**
     * @var ResponseFactory
     */
    private $responseFactory;

    /**
     * @var PerformanceListener
     */
    private $performance;

    /**
     * ResponseBuilder constructor.
     */
    public function __construct(PerformanceListener $performance)
    {
        $this->performance = $performance;
        $this->responseFactory = new ResponseFactory();
    }

    /**
     * @param ResponseData $responseData
     * @return ResponseInterface
     */
    public function buildResponse(ResponseData $responseData): ResponseInterface
    {
        $response = $this->responseFactory->response();
        $response->setLocale($responseData->getLocale());
        $response->setWebspace($responseData->getWebspace());
        $response->setHeaderHtml($responseData->getHeaderHtml());
        $response->setFooterHtml($responseData->getFooterHtml());

        //add script time
        $response->setScriptTimeSec($this->performance->getScriptSeconds());

        return $response;
    }
}
