<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\TemplateApiBundle\Configuration;

/**
 * Class TemplateConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Sulu\TemplateApiBundle\Configuration
 */
class TemplateConfiguration
{
    /**
     * @var array
     */
    private $availableLanguages = [];

    /**
     * @var string
     */
    private $headerTemplate;

    /**
     * @var string
     */
    private $footerTemplate;

    /**
     * TemplateConfiguration constructor.
     * @param array $availableLanguages
     * @param string $headerTemplate
     * @param string $footerTemplate
     */
    public function __construct(array $availableLanguages, string $headerTemplate, string $footerTemplate)
    {
        $this->availableLanguages = $availableLanguages;
        $this->headerTemplate = $headerTemplate;
        $this->footerTemplate = $footerTemplate;
    }

    /**
     * @return array
     */
    public function getAvailableLanguages(): array
    {
        return $this->availableLanguages;
    }

    /**
     * @return string
     */
    public function getHeaderTemplate(): string
    {
        return $this->headerTemplate;
    }

    /**
     * @return string
     */
    public function getFooterTemplate(): string
    {
        return $this->footerTemplate;
    }
}
