<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\TemplateApiBundle\Configuration;

use PHPUnit\Framework\TestCase;

/**
 * Class TemplateConfigurationTest
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Sulu\TemplateApiBundle\Configuration
 */
class TemplateConfigurationTest extends TestCase
{
    public function testGetters()
    {
        $faker = \Faker\Factory::create();
        $languages = array_fill(0, mt_rand(1, 5), $faker->locale);
        $headerTemplate = $faker->slug();
        $footerTemplate = $faker->slug();

        $templateConfiguration = new TemplateConfiguration(
            $languages,
            $headerTemplate,
            $footerTemplate
        );

        $this->assertEquals($languages, $templateConfiguration->getAvailableLanguages());
        $this->assertEquals($headerTemplate, $templateConfiguration->getHeaderTemplate());
        $this->assertEquals($footerTemplate, $templateConfiguration->getFooterTemplate());
    }
}
