<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sulu\TemplateBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sulu\TemplateBundle\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritDoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('lifestyle_sulu_template');

        $rootNode
            ->children()
                ->scalarNode('icon_font')->defaultValue('fal')->end()
                ->scalarNode('icon_brand_font')->defaultValue('fab')->end()
                ->scalarNode('icon_stack_circle')->defaultValue('fal')->end()
                ->scalarNode('icon_link')->defaultValue('fal fa-angle-right')->end()
                ->scalarNode('navigation_layout')->defaultValue('left')->end()
                ->booleanNode('has_shop')->defaultFalse()->end()
            ->end();

        return $treeBuilder;
    }
}
