export class Navbar {

    toggleAnimation (){
        let $navbarToggler = $('.navbar-toggler');

        $navbarToggler.on('click', function(){
            $navbarToggler.toggleClass('active');
            //$('body').toggleClass('open'); // Fix body Scroll on mobile
        });

        //$(window).resize(function(){ $('.navbar-toggler').removeClass('active');});
    }

    openSearch (){
        let $openSearchBtn = $('#open-search');
        $openSearchBtn.on('click', function() {
            $('#search-overlay').addClass('active');
            $('body').toggleClass('open');
            setTimeout(function() {
                $('input[name="search"]').focus();
            }, 500);
        });
    }

    closeSearch (){
        let $closeSearchBtn = $('#close-search');
        $closeSearchBtn.on('click', function() {
            $('#search-overlay').removeClass('active');
            $('body').removeClass('open');
        });

        $("#search-overlay").mouseup(function (e){
            var container = $(".search-overlay-content");
            if (!container.is(e.target) && container.has(e.target).length === 0)
            {
                $('#search-overlay').removeClass('active');
                $('body').removeClass('open');
            }
        });
    }

    stickyNavbar (){
        let $navbar = $('.lsnavbar-sticky');
        let $header = $('.header_page');

        if( $navbar[0] ){

            let limit = $navbar.outerHeight() + 50,
                scrolltop = $(window).scrollTop();
            //$('body').css('padding-top', limit); // Fix Body Padding on Sticky navbar

            $(window).on('scroll',function(){
                scrolltop = $(window).scrollTop();

                if( scrolltop > limit ) $navbar.addClass('sticked');
                if( scrolltop > limit + 100 ) $navbar.addClass('in');
                if( scrolltop === 0 ) $navbar.removeClass('sticked').removeClass('in')
            });
        }
    }

}

(function(document) {
    const navbar = new Navbar();
    navbar.toggleAnimation();
    navbar.openSearch();
    navbar.closeSearch();
    navbar.stickyNavbar();
})(document);