<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sulu\TemplateBundle\Twig;

/**
 * Class SuluBaseConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sulu\TemplateBundle\Twig
 */
class SuluBaseConfiguration
{
    /**
     * @var string
     */
    private $iconFont;

    /**
     * @var string
     */
    private $iconBrandFont;

    /**
     * @var string
     */
    private $iconStackCircle;

    /**
     * @var string
     */
    private $iconLink;

    /**
     * @var string
     */
    private $navigation_layout;

    /**
     * @var bool
     */
    private $hasShop;

    /**
     * SuluBaseConfiguration constructor.
     * @param string $iconFont
     * @param string $iconBrandFont
     * @param string $iconStackCircle
     * @param string $iconLink
     * @param string $navigation_layout
     * @param bool $hasShop
     */
    public function __construct($iconFont, $iconBrandFont, $iconStackCircle, $iconLink, $navigation_layout, $hasShop)
    {
        $this->iconFont = $iconFont;
        $this->iconBrandFont = $iconBrandFont;
        $this->iconStackCircle = $iconStackCircle;
        $this->iconLink = $iconLink;
        $this->navigation_layout = $navigation_layout;
        $this->hasShop = $hasShop;
    }

    /**
     * @return string
     */
    public function getIconFont()
    {
        return $this->iconFont;
    }

    /**
     * @return string
     */
    public function getIconBrandFont()
    {
        return $this->iconBrandFont;
    }

    /**
     * @return string
     */
    public function getIconStackCircle()
    {
        return $this->iconStackCircle;
    }

    /**
     * @return string
     */
    public function getIconLink()
    {
        return $this->iconLink;
    }

    /**
     * @return string
     */
    public function getNavigationLayout()
    {
        return $this->navigation_layout;
    }

    /**
     * @return bool
     */
    public function isHasShop()
    {
        return $this->hasShop;
    }
}
