/**
 * Get sylius status and change doom elements
 * @type {{init}}
 */

SyliusStatus = (function() {
    const statusUrl = '/' + config.locale + '/ajax/sylius/status-menu';
    const $cartContainer = $('#navbar-cart');
    const $userContainers = $('.navbar-user');

    function updateStatus() {
        let jqxhr = $.getJSON(statusUrl).done(function(html) {
            $cartContainer.empty();
            changeCartStatus(html.cart_status);
            changeUserStatus(html.user_status);
        });
    }

    function changeCartStatus(cartHtml) {
        $cartContainer.empty();
        $cartContainer.append(cartHtml);
        $cartContainer.find('.badge').fadeIn();
    }

    function changeUserStatus(userHtml) {
        $userContainers.each(function() {
            let $userContainer = $(this);
            $userContainer.empty();
            $userContainer.append(userHtml);
        });
    }

    /**
     * Initialization.
     */
    function init() {
        updateStatus();
    }

    return {
        init: init,
    };
}());

$(document).ready(function() {
    SyliusStatus.init();
});