export class Cookie {
    /**
     * Function to set the expire of a cookie
     * @param days integer
     * */
    setCookieExpire(days) {
        this.days = days;
        const date = new Date();
        if (this.days) {
            date.setTime(date.getTime()+(this.days*24*60*60*1000));
        } else {
            date.setTime(date.getTime()+(365*24*60*60*1000));
        }
        const expire = "expires="+date.toGMTString();
    }

    /**
     * Set a cookie
     * @param name string
     * @param value string
     * @param days integer
     * */
    setCookie(name, value, days) {
        this.name = name;
        this.value = value;
        this.days = days;
        this.cookieExpires = this.setCookieExpire(this.days);
        document.cookie = this.name + "=" + this.value + ";" + this.cookieExpires + ";path=/";
    }

    /**
     * Delete a cookie
     * @param name string
     * */
    deleteCookie(name) {
        this.name = name;
        document.cookie = this.name+"=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
    }

    /**
     * Get a cookie
     * @param name string
     * */
    getCookie(name) {
        this.name = name;
        const nameEQ = this.name + "=";
        const ca = document.cookie.split(';');
        for(let i=0;i < ca.length;i++) {
            let c = ca[i];
            while (c.charAt(0)===' ') c = c.substring(1,c.length);
            if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length,c.length);
        }
        return null;
    }
}

const cookies = new Cookie();