ScrollTo = (function() {
    var page = $('html, body');
    var headerHeight = 0;
    var outerHeight = $('.header_page').outerHeight();

    if(outerHeight){
        headerHeight = outerHeight;
    }


    var defaults = {
        offset: headerHeight,
        duration: 300,
        easing: 'swing',
        hold: (function() {
        }),
        complete: (function() {
        }),
    };

    /**
     * Get window.location.
     *
     * @param attributeName
     * @returns {*}
     */
    function getWindowLocation(attributeName) {
        var location = window.location;

        if (typeof (attributeName) === 'string' && typeof (location[attributeName]) !== 'undefined') {
            return location[attributeName];
        } else {
            return location;
        }
    }

    function isSamePath(pathOne, pathTwo) {
        pathOne = pathOne.replace(/^\//, '');
        pathTwo = pathTwo.replace(/^\//, '');

        return pathOne === pathTwo;
    }

    function isSameHost(hostOne, hostTwo) {
        return hostOne === hostTwo;
    }

    /**
     * Execute the scrolling animation to an element. Consider navigation height when scrolling.
     *
     * @param element
     * @param offset
     * @param duration
     * @param easing
     * @param hold
     * @param complete
     */
    function scrollTo(element, offset, duration, easing, hold, complete) {
        if (!element.length) {
            return;
        }

        // Use argument or defaults.
        offset = (typeof (offset) !== 'undefined') ? offset : defaults.offset;

        duration = (typeof (duration) !== 'undefined') ? duration : defaults.duration;
        easing = (typeof (easing) !== 'undefined') ? easing : defaults.easing;
        hold = (typeof (hold) !== 'undefined') ? hold : defaults.hold;
        complete = (typeof (complete) !== 'undefined') ? complete : defaults.complete;

        page.on('scroll mousedown wheel DOMMouseScroll mousewheel keyup touchmove', function(event) {
            page.stop();

            hold(event);
        });

        page.animate({
            scrollTop: element.offset().top - offset,
        }, duration, easing, function() {
            page.off('scroll mousedown wheel DOMMouseScroll mousewheel keyup touchmove');

            complete();
        });
    }

    /**
     * Handler for click events on a link.
     *
     * @param event
     */
    function handleClick(event) {
        var element = $(this);

        event.preventDefault();

        if (element.attr('href') === '#') {
            // Special case: Do nothing if link href is equal to "#" only
            return;
        }

        if (isSamePath(getWindowLocation('pathname'), this['pathname']) &&
            isSameHost(getWindowLocation('hostname'), this['hostname'])) {
            var targetHash = this['hash'];
            // The hash part is also the id selector
            var targetElement = $(targetHash);

            if (!targetElement.length) {
                targetHash = targetHash.substring(1);

                // If not found by id selector, try the name
                targetElement = $('[name="' + targetHash + '"]');
            }

            scrollTo(targetElement);
        }
    }

    /**
     * Register all events needed for this module.
     */
    function registerEvents() {
        // TODO: Make dynamic. But make sure dynamic update to the page are recognized.

        $('a.scroll-to').click(handleClick);
    }

    /**
     * Initialization.
     */
    function init() {
        registerEvents();
    }

    return {
        init: init,
        scrollTo: scrollTo,
    };
}());

$(document).ready(function() {
    ScrollTo.init();
});