<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sulu\TemplateBundle\Twig;

use Lifestyle\Sulu\TemplateBundle\Exception\InvalidArgumentException;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

/**
 * Class SuluBaseExtension
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sulu\TemplateBundle\Twig
 */
class SuluBaseExtension extends AbstractExtension
{
    /**
     * @var SuluBaseConfiguration
     */
    private $configuration;

    /**
     * SuluBaseExtension constructor.
     * @param SuluBaseConfiguration $configuration
     */
    public function __construct(SuluBaseConfiguration $configuration)
    {
        $this->configuration = $configuration;
    }

    /**
     * @return array|\Twig_Function[]
     */
    public function getFunctions()
    {
        return [
            new TwigFunction('ls_sulu_base_config', array($this, 'getBaseConfiguration')),
        ];
    }

    /**
     * @param string $key
     * @return mixed
     */
    public function getBaseConfiguration(string $key)
    {
        $getter = 'get' . ucfirst($key);
        if (!method_exists($this->configuration, $getter)) {

            $getter = 'is' . ucfirst($key);
            if (!method_exists($this->configuration, $getter)) {

                $getter = 'has' . ucfirst($key);
                if (!method_exists($this->configuration, $getter)) {
                    throw new InvalidArgumentException(sprintf('Twig configuration value "%s" does not exists.', $key));
                }
            }
        }

        return $this->configuration->$getter();
    }
}
