# Install and run Sulu with LifeStyle Themes

This is a composer-package and a npm-package at the same time. The composer-package is needed, the npm-package is optional, but makes live easier.

## Prepare your Sulu

Before you can use this package, you should have your Sulu installation up and running. Please visit the latest documentation of Sulu (http://docs.sulu.io/en/latest/book/getting-started.html).

## Install composer package

You must have access to the Life-Style repository. Add the following to the `repositories` section of your projects `composer.json`

```yaml
    "repositories": [
        ...
        {
            "type": "git",
            "url": "ssh://git@stash.life-style.de:7999/lsbx/sulu-base-theme"
        }
    ]
``` 

and install the package:

```bash
composer require lifestyle/sulu-template-bundle
```

Add the bundle to your Kernel `app/AbstractKernel.php`. You also have to enable the Symfony webpack-encore bundle, if not already done:

```php
abstract class AbstractKernel extends SuluKernel
{
    public function registerBundles()
    {
        $bundles = [
            ...
            new Symfony\WebpackEncoreBundle\WebpackEncoreBundle(),
            new Lifestyle\Sulu\TemplateBundle\LifestyleSuluTemplateBundle(),
            ...
        ];
        ...
    }
    ...
}
```

## Configure the composer-package

### Configure Image formats

Adjust your `app/config/image-formats.xml` or copy the file `config/image-formats.xml` from this package into your project to `app/config/image-formats.xml`.

### Configure Lifestyle Sulu Template Package

The package has its own configuration with default values properly set. The values can be overwritten by adding this to your `app/config/config.yml`:

```yaml
lifestyle_sulu_template:
    icon_font: "fal"
    icon_brand_font: "fab"
    icon_stack_circle: "fal"
    icon_link: "fal fa-angle-right"
    navigation_layout: "left"
    has_shop: false
```

### Configure Webpack Encore Package

If not already done you have to add this to your `app/config/website/config.yml`:

```yaml
framework:
    assets:
        packages:
            webpack:
                json_manifest_path: '%kernel.var_dir%/../web/build/manifest.json'
```

If you haven't create your `webpack.config.js` yet, you can use the file from this package and copy it to your projects root folder.

## Configure Sulu Core

You also have to adjust the Sulu core configuration in `app/config/config.yml`, if you want to use the predefined pages and snippets, which may be a good idea:

```yaml
sulu_core:
    content:
        structure:
            default_type:
                snippet: "default"
            paths:
                homepage:
                    path: "%kernel.root_dir%/../vendor/lifestyle/sulu-template-bundle/src/Resources/themes/default/templates/pages"
                    type: "home"
                page:
                    path: "%kernel.root_dir%/../vendor/lifestyle/sulu-template-bundle/src/Resources/themes/default/templates/pages"
                    type: "page"
                snippet:
                    path: "%kernel.root_dir%/../vendor/lifestyle/sulu-template-bundle/src/Resources/themes/default/templates/snippets"
                    type: "snippet"
```

You may have to adjust your webspace configuration in path `app/Resources/webspaces` to use templates from this package. The example file `config/ls-website-example.xml` is a good example to start with. Please adjust the name to your needs!

## Install and configure npm package

If your project has no `package.json`, run `npm init --yes` to create an initial configuration.

If your ssh key is password protected, first run:

```bash
eval `ssh-agent -s`
ssh-add
```

Run

```bash
npm install git+ssh://git@stash.life-style.de:7999/lsbx/sulu-base-theme.git --save
```

to add this package to your npm installation. Now you should be able to access the package-files in `assets` in your projects javascript.

To install the npm package from develop: `npm install git+ssh://git@stash.life-style.de:7999/lsbx/sulu-base-theme.git#develop --save`

To start simple, copy `config/webfontload.js` and `config/app.js` to `assets/js/` folder of your project, copy `config/app.scss` to `assets/scss/` folder of your project.

If FontAwesome Pro is needed, the key has to be configured. For development the Life-Style key can be used (https://password.life-style.de/cred/detail/2410/). 

```
npm config set "@fortawesome:registry" https://npm.fontawesome.com/ && npm config set "//npm.fontawesome.com/:_authToken" THE_KEY
npm install
```

---

# Remove eveything below if not needed anymore


## local Development

### Server start
```
export SYMFONY_ENV=dev
bin/console server:start
npm start
```

### Server stop
```
bin/console server:start
```

### Webpack
npm start

## Deployment Testserver
Node must be installed!
ssh root@.....

Git Pull (example Josera)
cd /var/www/sulu.josera.test.life-style.de/sulu-minimal/srcPackages/LifestyleSuluTemplateBundle
git pull

webpack run build 
cd /var/www/sulu.josera.test.life-style.de/sulu-minimal/
npm run build

change owner 
cd /var/www/sulu.josera.test.life-style.de/
chown -R nginx.nginx .

clear cache
sudo -u nginx php -dmemory_limit=-1 bin/adminconsole cache:clear --env=prod
sudo -u nginx php -dmemory_limit=-1 bin/websiteconsole cache:clear --env=prod
