lazyVideo = (function() {

    function init() {
        loadYoutube();
        loadVimeo();
    }

    function loadYoutube() {
        var youtube = $('.youtubevideo');

        if (youtube.length <= 0) {
            return;
        }
        for (var i = 0; i < youtube.length; i++) {

            var source = 'https://img.youtube.com/vi/' + youtube[i].dataset.embed + '/sddefault.jpg';

            var image = new Image();
            image.src = source;
            image.addEventListener('load', function() {
                youtube[i].appendChild(image);
            }(i));

            youtube[i].addEventListener('click', function() {

                var iframe = document.createElement('iframe');

                iframe.setAttribute('frameborder', '0');
                iframe.setAttribute('allowfullscreen', '1');
                iframe.setAttribute('src', 'https://www.youtube.com/embed/' + this.dataset.embed +
                    '?enablejsapi=1&controls=0&fs=0&iv_load_policy=3&rel=0&showinfo=0&loop=1&start=102&rel=0&autoplay=1&playlist='+ this.dataset.embed);
                this.innerHTML = '';
                this.appendChild(iframe);
                resizePlayer(iframe, 16/9);
            });
        }
    }

    function loadVimeo() {
        var video = $('.vimeovideo');

        if (video.length <= 0) {
            return;
        }
        for (var i = 0; i < video.length; i++) {

            var videoId = video[i].dataset.embed;

            var image = new Image();
            image.src = getVimeoImage(videoId);
            image.id = videoId;

            image.addEventListener('load', function() {
                video[i].appendChild(image);
            }(i));

            video[i].addEventListener('click', function() {

                var iframe = document.createElement('iframe');

                iframe.setAttribute('frameborder', '0');
                iframe.setAttribute('allowfullscreen', '');
                iframe.setAttribute('src', '//player.vimeo.com/video/' + this.dataset.embed +
                    '?rel=0&fullscreen=1&autoplay=1');

                this.innerHTML = '';
                this.appendChild(iframe);
            });
        }
    }

    function getVimeoImage(id) {
        var imgScr = '/img/no-video.png';
        var queryId = '#' + id;

        $.ajax({
            type: 'GET',
            url: 'https://vimeo.com/api/v2/video/' + id + '.json',
            jsonp: 'callback',
            dataType: 'jsonp',
            cache: false,
            global: false,
            async: false,
            success: function(data) {
                $(queryId).attr('src', data[0].thumbnail_large);
            },
        });
        return imgScr;
    }

    // Resize player
    function resizePlayer(iframes, ratio) {
        if (!iframes[0]) return;
        var win = $(".main-slider"),
            width = win.width(),
            playerWidth,
            height = win.height(),
            playerHeight,
            ratio = ratio || 16/9;

        iframes.each(function(){
            var current = $(this);
            if (width / ratio < height) {
                playerWidth = Math.ceil(height * ratio);
                current.width(playerWidth).height(height).css({
                    left: (width - playerWidth) / 2,
                    top: 0
                });
            } else {
                playerHeight = Math.ceil(width / ratio);
                current.width(width).height(playerHeight).css({
                    left: 0,
                    top: (height - playerHeight) / 2
                });
            }
        });
    }

    return {
        init: init,
    };

}());

$(document).ready(function() {
    lazyVideo.init();
});


