$(document).ready(function() {

    /**
     * check, if IE11 is used
     */

    function checkIEVersion() {
        var userAgent = window.navigator.userAgent;
        var userAgentIndex = userAgent.indexOf("MSIE");

        // If IE, return version number.
        if (userAgentIndex > 0) {
            return parseInt(userAgent.substring(userAgentIndex + 5, userAgent.indexOf(".", userAgentIndex)));
        } else if (!!navigator.userAgent.match(/Trident\/7\./)) {
            return 11;
        } else {
            return 0; //It is not IE
        }
    }

    if (checkIEVersion() < 11) {
        import('@yaireo/fakescroll/fakescroll');
    }

    /**
     * scrollbars
     */

    var trials = 0;

    function checkFakeScroll() {
        if (checkIEVersion() < 11) {
            var divs = document.querySelectorAll('.scrollbars');
            var ii = 0;
            if (divs[ii] == undefined || divs[ii].fakeScroll == undefined) {
                ++trials;
                if (trials < 10) {
                    window.setTimeout(checkFakeScroll, 100);
                } else {
                    window.clearTimeout();
                }
            } else {
                for (ii = 0; ii < divs.length; ++ii) {
                    divs[ii].fakeScroll();
                }
            }
        }
    }

    checkFakeScroll();

    var $filterform = $( "#filter-panel form" );

    $filterform.find('input[type="checkbox"], input[type="radio"]').on('change', function() {
        $filterform.submit();
    });

    $filterform.find('select').on('change', function() {
        $filterform.submit();
    });

    function resetForm($filterform) {
        $filterform.find('input:text, input:password, input:file, select, textarea').val('');
        $filterform.find('input:radio, input:checkbox')
        .removeAttr('checked').removeAttr('selected');
    }

    $('.resetfilter').on('click', function() {
        resetForm($($filterform));
        $filterform.submit();
    });

    if ($filterform.find('input:radio:checked, input:checkbox:checked').length > 0) {
        $('.resetfilter').addClass('shown');
    }

    $filterform.find('input:text, input:password, input:file, select, textarea').each(function(){
        if($(this).val() !== "") {
            $('.resetfilter').addClass('shown');
        }
    });
});