AnchorNavigation = (function() {

    var container = $('#content');
    var navigationBlock = container.find('.block-anchor-navigation');

    var classes = [
        '.container',
    ];


    /**
     * Append given content template to given element.
     * Normally the element is of type list and the content a list of links as html string.
     *
     * @param element
     * @param content
     */
    function appendContent(element, content) {
        if (!element.length) {
            return;
        }

        element.append(content);
    }

    /**
     * Show given element and append given content template.
     *
     * @param element
     * @param contentElement
     * @param content
     */
    function showContent(element, contentElement, content) {
        if (!element.length || !contentElement.length) {
            return;
        }

        element.show();

        appendContent(contentElement, content);
    }

    /**
     * Get all elements of type link-anchor inside of given section.
     *
     * @param section
     */
    function getAnchors(section) {
        return section.find('.link-anchor');
    }

    /**
     * Get all stages with given classes until next stage of type anchor-navigation.
     *
     * @param navigation
     * @param classes
     */
    function getSections(navigation, classes) {
        return navigation.nextUntil('.block-anchor-navigation', classes.join(', '));
    }

    /**
     * Get all stages of type anchor-navigation inside of given container.
     *
     * @param container
     */
    function getNavigations(container) {
        return container.find('.block-anchor-navigation');
    }

    /**
     * Generate the template html string from elements on the page.
     */
    function generate() {
        getNavigations(container).each(function (index, navigation) {
            navigation = $(navigation);

            var template = '';

            getSections(navigation, classes).each(function (index, section) {
                section = $(section);

                console.log(section);

                getAnchors(section).each(function (index, anchor) {
                    anchor = $(anchor);

                    var text = anchor.text();
                    var link = anchor.attr('id');

                    template += '<li>';
                    /**/template += '<a href="' + '#' + link + '" class="scroll-to">';
                    /**//**/template += text;
                    /**/template += '</a>';
                    template += '</li>';

                });
            });

            var blockId = '#' + navigation.attr('id');
            // Guess child element ids
            var navigationId = blockId + '-content';
            var navigationListId = blockId + '-list';

            // Append content to the current navigation.
            showContent(navigation, navigation.find(navigationListId), template);
        });
    }

    /**
     * Initialization.
     */
    function init() {
        if (!container.length) {
            return;
        }

        generate();
    }

    return {
        init: init
    };

}());

$(document).ready(function() {
    AnchorNavigation.init();
});