export class Navbar {

    toggleAnimation() {
        let $navbarToggler = $('.navbar-toggler');

        $navbarToggler.on('click', function() {
            $navbarToggler.toggleClass('active');
            $('body').toggleClass('open'); // Fix body Scroll on mobile
        });

        //$(window).resize(function(){ $('.navbar-toggler').removeClass('active');});
    }

    openSearch() {
        let $openSearchBtn = $('#open-search');
        $openSearchBtn.on('click', function() {
            $('#search-overlay').addClass('active');
            $('body').toggleClass('open');
            setTimeout(function() {
                $('#search-overlay-input').focus();
            }, 500);
        });
    }

    closeSearch() {
        let $closeSearchBtn = $('#close-search');
        $closeSearchBtn.on('click', function() {
            $('#search-overlay').removeClass('active');
            $('body').removeClass('open');
        });

        $('#search-overlay').mouseup(function(e) {
            var container = $('.search-overlay-content');
            if (!container.is(e.target) && container.has(e.target).length === 0) {
                $('#search-overlay').removeClass('active');
                $('body').removeClass('open');
            }
        });
    }

    stickyNavbar() {
        let $header = $('.header_page');
        let $headerTop = $header.find('.header_top');
        let $navbar = $header.find('.lsnavbar-sticky');

        if ($navbar[0]) {

            let limit = $header.outerHeight(),
                scrolltop = $(window).scrollTop();

            $(window).on('scroll', function() {
                scrolltop = $(window).scrollTop();

                if (scrolltop > limit) {
                    $navbar.addClass('sticked');
                    $header.css('margin-bottom', limit); // Fix Body Padding on Sticky navbar
                }
                if (scrolltop > limit + 100) {
                    $navbar.addClass('in');
                }
                if (scrolltop === 0) {
                    $navbar.removeClass('sticked').removeClass('in');
                    $header.css('margin-bottom', 0); // Fix Body Padding on Sticky navbar
                }
            });
        }
    }

}

(function(document) {
    const navbar = new Navbar();
    navbar.toggleAnimation();
    navbar.openSearch();
    navbar.closeSearch();
    navbar.stickyNavbar();
})(document);