var arrowRight = '<i class="arrow slick-next">\n' +
    '            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="40px" height="80px" viewBox="0 0 50 80" xml:space="preserve">\n' +
    '                <polyline fill="none" stroke="#FFFFFF" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" points="\n' +
    '                0.375,0.375 45.63,38.087 0.375,75.8 "/>\n' +
    '              </svg>\n' +
    '        </i>';
var arrowLeft = '<i class="arrow slick-prev">\n' +
    '            <svg width="40px" height="80px" viewBox="0 0 50 80" xml:space="preserve">\n' +
    '                <polyline fill="none" stroke="#FFFFFF" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" points="\n' +
    '                45.63,75.8 0.375,38.087 45.63,0.375 "/>\n' +
    '            </svg>\n' +
    '        </i>';

var slideWrapper = $('.js-slider-heroimage'),
    iframes = slideWrapper.find('.embed-player'),
    lazyImages = slideWrapper.find('.slide-image'),
    lazyCounter = 0;

// POST commands to YouTube or Vimeo API
function postMessageToPlayer(player, command) {
    if (player == null || command == null) return;
    player.contentWindow.postMessage(JSON.stringify(command), '*');
}

// When the slide is changing
function playPauseVideo(slick, control) {
    var currentSlide, slideType, startTime, player, video;

    currentSlide = slick.find('.slick-current');
    slideType = currentSlide.find('.item').attr('data-videotype');
    player = currentSlide.find('iframe').get(0);
    startTime = currentSlide.data('video-start');

    if (slideType === 'vimeo') {
        switch (control) {
            case 'play':
                if ((startTime != null && startTime > 0) && !currentSlide.hasClass('started')) {
                    currentSlide.addClass('started');
                    postMessageToPlayer(player, {
                        'method': 'setCurrentTime',
                        'value': startTime,
                    });
                }
                postMessageToPlayer(player, {
                    'method': 'play',
                    'value': 1,
                });
                break;
            case 'pause':
                postMessageToPlayer(player, {
                    'method': 'pause',
                    'value': 1,
                });
                break;
        }
    } else if (slideType === 'youtube') {
        switch (control) {
            case 'play':
                postMessageToPlayer(player, {
                    'event': 'command',
                    'func': 'mute',
                });
                postMessageToPlayer(player, {
                    'event': 'command',
                    'func': 'playVideo',
                });
                break;
            case 'pause':
                postMessageToPlayer(player, {
                    'event': 'command',
                    'func': 'pauseVideo',
                });
                break;
        }
    } else if (slideType === 'video') {
        video = currentSlide.children('video').get(0);
        if (video != null) {
            if (control === 'play') {
                video.play();
            } else {
                video.pause();
            }
        }
    }
}

// Resize player
function resizePlayer(iframes, ratio) {
    if (!iframes[0]) return;
    var win = $('.js-slider-heroimage'),
        width = win.width(),
        playerWidth,
        height = win.height(),
        playerHeight,
        ratio = ratio || 16 / 9;

    iframes.each(function() {
        var current = $(this);
        if (width / ratio < height) {
            playerWidth = Math.ceil(height * ratio);
            current.width(playerWidth).height(height).css({
                left: (width - playerWidth) / 2,
                top: 0,
            });
        } else {
            playerHeight = Math.ceil(width / ratio);
            current.width(width).height(playerHeight).css({
                left: 0,
                top: (height - playerHeight) / 2,
            });
        }
    });
}

// DOM Ready
$(function() {
    // Initialize
    slideWrapper.on('init', function(slick) {

        slick = $(slick.currentTarget);

        var videos = document.getElementsByTagName("iframe"), fraction = 0.8;

        function checkScroll() {
            for(var i = 0; i < videos.length; i++) {
                var video = videos[i];

                var x = 0,
                    y = 0,
                    w = video.width,
                    h = video.height,
                    r, //right
                    b, //bottom
                    visibleX, visibleY, visible,
                    parent;

                parent = video;
                while (parent && parent !== document.body) {
                    x += parent.offsetLeft;
                    y += parent.offsetTop;
                    parent = parent.offsetParent;
                }

                r = x + parseInt(w);
                b = y + parseInt(h);

                visibleX = Math.max(0, Math.min(w, window.pageXOffset + window.innerWidth - x, r - window.pageXOffset));
                visibleY = Math.max(0, Math.min(h, window.pageYOffset + window.innerHeight - y, b - window.pageYOffset));

                visible = visibleX * visibleY / (w * h);

                if (visible > fraction) {
                    setTimeout(function playVideo() {
                        playPauseVideo(slick, 'play');
                    }, 500);
                } else {
                    playPauseVideo(slick, 'pause');
                }
            }
        }

        window.addEventListener('scroll', checkScroll, false);
        window.addEventListener('resize', checkScroll, false);

        // setTimeout(function () {
        //     playPauseVideo(slick, 'play');
        // }, 500);

        //check at least once so you don't have to wait for scrolling for the video to start
        window.addEventListener('load', checkScroll, false);
        setTimeout(function() {
            checkScroll();
        }, 2000);

        resizePlayer(iframes, 16 / 9);

    });
    slideWrapper.on('beforeChange', function(event, slick) {
        slick = $(slick.$slider);
        playPauseVideo(slick, 'pause');
    });
    slideWrapper.on('afterChange', function(event, slick) {
        slick = $(slick.$slider);
        playPauseVideo(slick, 'play');
    });
    slideWrapper.on('lazyLoaded', function(event, slick, image, imageSource) {
        lazyCounter++;
        if (lazyCounter === lazyImages.length) {
            lazyImages.addClass('show');
            // slideWrapper.slick("slickPlay");
        }
    });

    //start the slider
    slideWrapper.slick({
        // fade:true,
        autoplaySpeed: 4000,
        lazyLoad: 'progressive',
        speed: 600,
        arrows: true,
        adaptiveHeight: false,
        dots: true,
        nextArrow: arrowRight,
        prevArrow: arrowLeft,
        cssEase: 'cubic-bezier(0.87, 0.03, 0.41, 0.9)',
    });
});

// Resize event
$(window).on('resize.slickVideoPlayer', function() {
    resizePlayer(iframes, 16 / 9);
});