<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sulu\TemplateBundle\DependencyInjection;

use Lifestyle\Sulu\TemplateBundle\Twig\SuluBaseConfiguration;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * Class LifestyleSuluTemplateExtension
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sulu\TemplateBundle\DependencyInjection
 */
class LifestyleSuluTemplateExtension extends Extension
{
    /**
     * {@inheritDoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $config = $this->processConfiguration(new Configuration(), $configs);

        (new Loader\YamlFileLoader(
            $container,
            new FileLocator(dirname(__DIR__) . '/Resources/config'))
        )->load('services.yaml');

        $this->configureTwigExtension($config, $container);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureTwigExtension(array $config, ContainerBuilder $container)
    {
        if (!$container->hasDefinition(SuluBaseConfiguration::class)) {
            return;
        }

        $definition = $container->getDefinition(SuluBaseConfiguration::class);
        $definition->setArguments([
            $config['icon_font'],
            $config['icon_brand_font'],
            $config['icon_stack_circle'],
            $config['icon_link'],
            $config['navigation_layout'],
            $config['has_shop'],
        ]);
    }
}
