/**
 * Resize Video-Player
 * embedded or video
 */

let videoContainer;
let fraction = 0.8;

// DOM Ready
$(function() {
    videoContainer = $('.html5player')
});



function resizePlayer(videoContainer, ratio) {
    if (!videoContainer[0]) return;
    var win = videoContainer.parent(),
        width = win.width(),
        breakWith = 800,
        playerWidth,
        height = win.height(),
        playerHeight,
        ratio = ratio || 16 / 9;

    if (width < breakWith ){
        win.addClass('video-expand-height')
    }else{
        win.removeClass('video-expand-height')
    }
    videoContainer.each(function() {
        var current = $(this).find('iframe');
        if (width / ratio < height) {
            playerWidth = Math.ceil(height * ratio);
            current.width(playerWidth).height(height).css({
                left: (width - playerWidth) / 2,
                top: 0,
            });
        } else {
            playerHeight = Math.ceil(width / ratio);
            current.width(width).height(playerHeight).css({
                left: 0,
                top: (height - playerHeight) / 2,
            });
        }
    });
}

// Resize event
$(window).on('resize', function() {
    resizePlayer(videoContainer, 16 / 9);
});
