import {configSliderHeroimage} from './configs/_config-slider-heroimage';
import {configSliderTextblock} from './configs/_config-slider-textblock';
import {configSliderProducts} from './configs/_config-slider-products';
import {configSliderTestimonials} from './configs/_config-slider-testimonial';
import {configSliderOther} from './configs/_config-slider-other';

export default class Slider {

    constructor(select, options) {
        const arrowRight = '<i class="arrow slick-next">\n' +
            '            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="40px" height="80px" viewBox="0 0 50 80" xml:space="preserve">\n' +
            '                <polyline fill="none" stroke="#FFFFFF" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" points="\n' +
            '                0.375,0.375 45.63,38.087 0.375,75.8 "/>\n' +
            '              </svg>\n' +
            '        </i>';
        const arrowLeft = '<i class="arrow slick-prev">\n' +
            '            <svg width="40px" height="80px" viewBox="0 0 50 80" xml:space="preserve">\n' +
            '                <polyline fill="none" stroke="#FFFFFF" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" points="\n' +
            '                45.63,75.8 0.375,38.087 45.63,0.375 "/>\n' +
            '            </svg>\n' +
            '        </i>';

        this.selector = select;
        this.options = options;
        this.options.nextArrow = this.options.nextArrow || arrowRight;
        this.options.prevArrow = this.options.prevArrow || arrowLeft;
    }

    initSlider() {
        let $slickSlider = $(this.selector);
        if ($slickSlider.length && $slickSlider.find('.item').length > 1 ){
            $slickSlider.slick(this.options);
        }
    }
}

//const heroImageSlider = new Slider($('.js-slider-heroimage-old'), configSliderHeroimage);
//heroImageSlider.initSlider();

const textblockSlider = new Slider($('.js-slider-textblock'), configSliderTextblock);
textblockSlider.initSlider();

const productSlider = new Slider($('.js-slider-products'), configSliderProducts);
productSlider.initSlider();

const testimonialSlider = new Slider($('.js-slider-testimonial'), configSliderTestimonials);
testimonialSlider.initSlider();

const textImageSlider = new Slider($('.block-text-image__slider'), configSliderOther);
textImageSlider.initSlider();

const sliderTextImage = new Slider($('.slider-text-image__slider'), configSliderOther);
sliderTextImage.initSlider();
