/**
 * scrollbars
 */

import PerfectScrollbar from 'perfect-scrollbar';

/**
 * init perfectScrllbars on
 *
 */
function initScrollbars(){
    const $filterContainer = $('.searchresults__filter');

    if (!$filterContainer.length) {
        return;
    }

    let divs = document.querySelectorAll('.scrollbars'), i;

    for (i = 0; i < divs.length; ++i) {
        const ps = new PerfectScrollbar(divs[i]);
    }
}

$(document).ready(function() {
    initScrollbars();

    const $filterform = $( "#filter-panel form, .filter-panel form" );
    let $resetFilterButton = $('.resetfilter');

    $filterform.find('input[type="checkbox"], input[type="radio"]').on('change', function() {
        $filterform.submit();
    });

    $filterform.find('select').on('change', function() {
        $filterform.submit();
    });

    function resetForm($filterform) {
        $filterform.find('input:text, input:password, input:file, select, textarea').val('');
        $filterform.find('input:radio, input:checkbox')
        .removeAttr('checked').removeAttr('selected');
    }

    $resetFilterButton.on('click', function() {
        resetForm($($filterform));
        $filterform.submit();
    });

    if ($filterform.find('input:radio:checked, input:checkbox:checked').length > 0) {
        $resetFilterButton.addClass('shown');
    }

    $filterform.find('input:text, input:password, input:file, select, textarea').each(function(){
        if($(this).val() !== "") {
            $resetFilterButton.addClass('shown');
        }
    });
});
